﻿var importWizard = {
    context: $("#importWizard"),
    allowedFormatExtensions: null,
    mappingDataTable: null,
    mappingData: [],
    mappingFields: [],
    mappingVariables: [],
    previewData: null,
    formatHasMappingTable: function () {
        return (importationFormat == Enum.DtsTypes.Access || importationFormat == Enum.DtsTypes.Csv || importationFormat == Enum.DtsTypes.Xml || importationFormat == Enum.DtsTypes.Txt);
    },
    initialize: function () {
        if (importWizard.formatHasMappingTable()) {
            new Promise(function(resolve) {
                importWizard.initializeMappingDataTable(resolve);
            }).then(function() {
                // get existing data map
                var importationDataMapJson =
                    $("#ImportTaskConfiguration_ImportationDataMapJson", importWizard.context).val();

                if (importationDataMapJson != "") {
                    importWizard.mappingData = JSON.parse(importationDataMapJson);
                    importWizard.refreshMappingTable();
                }
            });
        }

        if (!readOnly) {
            var isUpdateResponsesOnly = $(".v-updateResponsesOnly", importWizard.context).prop('checked');

            $(".v-duplicateRecordNumbersOption", importWizard.context).prop("disabled", isUpdateResponsesOnly);
            $(".v-importAsInactiveSample", importWizard.context).prop("disabled", isUpdateResponsesOnly);

            if (importationFormat == Enum.DtsTypes.CaseGenerator)
                $(".v-pinOptions option[value=" + Enum.PinOptions.Import + "]", importWizard.context).remove();
        }
    },
    bindEvents: function () {
        importWizard.context.on("change", ".v-fileSource", function () {
            var isUploadFile = $(this).val() == "Upload";
            var fileUploadField = $(".h-fileUploadField", importWizard.context);

            $(".v-fileUpload, .v-allowedExtensions", fileUploadField).toggleClass("hidden", !isUploadFile);
            $(".v-fileSelect", fileUploadField).toggleClass("hidden", isUploadFile);
        });

        importWizard.context.on("change", ".v-accessTableToImport", function () {
            var fileName = importWizard.getFileName();

            if (fileName)
                fileUploader.refreshFieldsDataTable(fileName, $(this).val(), $(".v-autoFieldMapping", importWizard.context).is(":checked"));
        });

        importWizard.context.on("change", ".v-fileDelimiter", function () {
            var fileName = importWizard.getFileName();

            if (fileName)
                fileUploader.refreshFieldsDataTable(fileName, null, true);
        });

        importWizard.context.on("change", ".v-duplicateRecordNumbersOption", function () {
            $(".v-updateResponsesOnly", importWizard.context).prop("disabled", ($(this).val() == Enum.DuplicateRecordNumbersOptions.Update));
        });

        importWizard.context.on("change", ".v-updateResponsesOnly", function () {
            var isChecked = $(this).is(':checked');

            $(".v-duplicateRecordNumbersOption", importWizard.context).prop("disabled", isChecked);
            $(".v-importAsInactiveSample", importWizard.context).prop("disabled", isChecked);
            $(".v-updateResponsesBaseField", importWizard.context).toggle(isChecked);
        });

        importWizard.context.on("change", ".v-pinOptions", function () {
            var selectedValue = $(this).val();

            $(".v-pinQuestionSection").toggle(selectedValue != Enum.PinOptions.NoPin);
            $(".v-pinMaskSection").toggle(selectedValue == Enum.PinOptions.Generate);

            if (selectedValue == Enum.PinOptions.Generate) {
                var questionLength = 40; // $N return a 0 length value, so we add default length = 40 in that case
                var mask = "9999999999";

                $('.v-pinMask').maxLength = questionLength;
                $('.v-pinMask').val(mask.substring(0, questionLength)); // Fill up the mask with standard mask of the question max length
            }
        });

        importWizard.context.on("click", ".v-PINMaskHelp", function () {
            $(this).find(".v-text").show();
        })
        .on("mouseleave", ".v-PINMaskHelp", function () {
            $(this).find(".v-text").hide();
        });

        importWizard.context.on("keydown", ".v-validatePositiveInt", function (event) {
            a4.validateNumberKeyCode(event, false);
        });

        importWizard.context.on("click", ".h-submitImport", function () {
            return importWizard.validateFiles() && importWizard.validateFieldMappingRows();
        });
    },
    setFormElementsReadOnly: function (readOnly) {
        if (readOnly)
        {
            $(".v-fileUploadSection form", importWizard.context).each(function () {
                $(this).find(".h-deleteFile").hide();
            });
        }
    },
    initializeAutocompletes: function () {
        $(".h-questions-autocomplete", importWizard.context).a4autocomplete({
            ajaxAction: a4.getProjectAction("GetQuestionnaireQuestions", "Importation"),
            ajaxParams: { dtsType: importationFormat, questionType: Enum.QuestionTypesEnum.Pin },
            valueProperty: "Name",
            labelProperty: "Name",
            altValueField: $("#ImportTaskConfiguration_PinQuestion", importWizard.context),
        });

        $(".h-responseOnlyQuestions-autocomplete", importWizard.context).a4autocomplete({
            ajaxAction: a4.getProjectAction("GetQuestionnaireQuestions", "Importation"),
            ajaxParams: { dtsType: importationFormat, questionType: Enum.QuestionTypesEnum.All },
            valueProperty: "Name",
            labelProperty: "Name",
            altValueField: $("#ImportTaskConfiguration_UpdateResponsesBaseField", importWizard.context),
        });

        importWizard.setMappingVariables();
    },
    setMappingVariables: function () {
        a4.callServerMethod(
            a4.getProjectAction("GetQuestionnaireQuestions", "Importation"), { dtsType: importationFormat, questionType: Enum.QuestionTypesEnum.FieldMapping },
            function (result) {
                importWizard.mappingVariables = result;
                importWizard.initializeMappingVariableAutocomplete();

                var fields = _.find(result, function (e) { return e.Name == "S_DIM" || e.Name == "S_VIM"; });

                if (typeof fields != "undefined")
                    $(".v-importDateAndNumberInfo", importWizard.context).show();
            }
        );
    },
    initializeMappingVariableAutocomplete: function (input) {
        var input = input || $(".v-interviewerFieldNameInput input", importWizard.mappingDataTable);

        input.a4autocomplete({
            valueProperty: "Name",
            labelProperty: "Name",
            data: importWizard.mappingVariables,
            select: function (event, data) {
                var value = data.item ? data.item.Name : undefined;
                var row = $(this).closest("tr");

                $(".v-interviewerFieldName", row).html(value);
                importWizard.updateMappingRow(row.attr("data-index"), "InterviewerFieldName", value);
            }
        });
    },
    initializeFieldMappingAutocomplete: function (input) {
        if (input) {
            var property = (importationFormat == Enum.DtsTypes.Access) ? "SourceFieldName" : "Position";

            input.a4autocomplete({
                valueProperty: property,
                labelProperty: property,
                data: importWizard.mappingFields,
                select: function (event, data) {
                    var sourceFieldName = data.item ? data.item.SourceFieldName : "";
                    var sourceColumn = data.item ? data.item.SourceColumn : "";
                    var position = data.item ? data.item.Position : "";
                    var row = $(this).closest("tr");

                    $(".v-sourceFieldName", row).html(sourceFieldName);
                    $(".v-sourceColumn", row).html(sourceColumn);
                    $(".v-position", row).html(position);

                    importWizard.updateMappingRow(row.attr("data-index"), "SourceFieldName", sourceFieldName);
                    importWizard.updateMappingRow(row.attr("data-index"), "SourceColumn", sourceColumn);
                    importWizard.updateMappingRow(row.attr("data-index"), "Position", position);
                },
            });
        }
    },
    initializeMappingDataTable: function (initializeMappingDataTableCallback) {
        importWizard.mappingDataTable = $('.v-fieldVariableMappingTable').a4datatable({
            serverSide: false,
            data: importWizard.mappingData,
            columns: importWizard.getDataTableColumns(),
            toolBar: { Items: importWizard.getToolBarItems(), DisplayMode: dataTables.filterDisplayMode.buttons },
            contextMenuItems: importWizard.getContextMenuItems(),
            displayColumnSelector: false,
            deferRender: false,
            toolBarClick: function (event, data) {
                var action = data.action;
                var rows = data.rows;

                if (action == "addVariable")
                {
                    importWizard.mappingData.push(importWizard.getMappingDataRow());
                    importWizard.refreshMappingTable();
                }
                else if (action == "selectVariables")
                {
                    importWizard.selectVariables();
                }
                else if (action == "copyFrom")
                {
                    var params = {
                        dtsType: importationFormat,
                        selectedSourceValue: importationFormat == Enum.DtsTypes.Access ? $(".v-accessTableToImport", importWizard.context).val() : "",
                        fileDelimiter: importationFormat == Enum.DtsTypes.Csv ? $(".v-fileDelimiter", importWizard.context).val() : "",
                        filePath: importWizard.getFullFilePath()
                    };

                    modalDialog.showWindow(a4.getProjectAction("CopyFieldMappingFrom", "Importation", params), 300, 600);
                }
                else if (action == "load")
                {
                    var fileName = importWizard.getFileName();
                    var selectedTable = null;

                    if (importationFormat == Enum.DtsTypes.Access)
                        selectedTable = $(".v-accessTableToImport", importWizard.context).val();

                    if (fileName)
                        fileUploader.refreshFieldsDataTable(fileName, selectedTable, true);
                }
                else if (action == "preview")
                {
                    if (importWizard.validateFieldMappingRows())
                    {
                        a4.callServerMethod(a4.getProjectAction("GetImportPreviewData", "Importation"), { importTaskConfiguration: importWizard.getImportTaskConfiguration() }, function (result) {
                            importWizard.previewData = result;
                            modalDialog.showWindow(a4.getProjectAction("ImportPreview", "Importation"), 700, 950);
                        });
                    }
                }
                else if (action == "delete")
                {
                    importWizard.deleteMappingRows(rows);
                }
            },
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "delete":
                        importWizard.deleteMappingRows([row]);
                        break;
                }
            },
            rowCreated: function (e, d) {
                importWizard.createDataMapRow(d.row, d.index);
            },
            createCallback: initializeMappingDataTableCallback
        });

        importWizard.mappingDataTable.on("change", ".h-positionInput", function (e) {
            var row = $(this).parents("tr")[0];
            var dataIndex = $(row).attr("data-index");
            var value = parseInt($(this).val());

            importWizard.updateMappingRow(dataIndex, "SourceColumn", value-1);
            importWizard.updateMappingRow(dataIndex, "Position", value);
        });

        importWizard.mappingDataTable.on("change", ".h-lengthInput", function (e) {
            var row = $(this).parents("tr")[0];
            importWizard.updateMappingRow($(row).attr("data-index"), "SourceLength", parseInt($(this).val()));
        });
    },
    getDataTableColumns: function () {
        var columns = [];
        var hiddenColumn = "hidden-column";

        columns.push({ "Title": "SourceRecordNo", "Data": "SourceRecordNo", "Class": "hidden-column v-sourceRecordNo", "Sortable": false });
        columns.push({ "Title": "ImportAsCode", "Data": "ImportAsCode", "Class": "hidden-column v-importAsCode", "Sortable": false });
        columns.push({ "Title": "SkipIfPresent", "Data": "InterviewSkipIfPresent", "Class": "hidden-column v-skipIfPresent", "Sortable": false });
        columns.push({ "Title": "SkipIfAbsent", "Data": "InterviewSkipIfAbsent", "Class": "hidden-column v-skipIfAbsent", "Sortable": false });
        columns.push({ "Title": "IsQuestion", "Data": "IsQuestion", "Class": "hidden-column v-isQuestion", "Sortable": false });

        columns.push({ "Title": "InterviewerFieldName", "Data": "InterviewerFieldName", "Class": "hidden-column v-interviewerFieldName", "Sortable": false });
        columns.push({ "Title": "SourceColumn", "Data": "SourceColumn", "Class": "hidden-column v-sourceColumn", "Sortable": false });
        columns.push({ "Title": "SourceLength", "Data": "SourceLength", "Class": "hidden-column v-sourceLength", "Sortable": false });
        columns.push({ "Title": "Position", "Data": "Position", "Class": "hidden-column v-position", "Sortable": false });

        columns.push({ "Title": resources.variable, "Data": null, "Class": "v-interviewerFieldNameInput", "Sortable": false });

        if (importationFormat == Enum.DtsTypes.Access)
        {
            columns.push({ "Title": resources.field, "Data": null, "Class": "v-sourceFieldNameInput", "Sortable": false });
        }
        else if (importationFormat == Enum.DtsTypes.Csv || importationFormat == Enum.DtsTypes.Txt)
        {
            columns.push({ "Title": resources.position, "Data": null, "Class": "v-positionInput", "Sortable": false });

            if (importationFormat == Enum.DtsTypes.Txt) {
                columns.push({ "Title": resources.length, "Data": null, "Class": "v-sourceLengthInput", "Sortable": false });
            }
            else if (importationFormat == Enum.DtsTypes.Csv) {
                hiddenColumn = "";
            }
        }

        columns.push({ "Title": resources.field, "Data": "SourceFieldName", "Class": hiddenColumn + " v-sourceFieldName", "Sortable": false });

        return columns;
    },
    getToolBarItems: function () {
        var items = Array();

        if (!readOnly) {
            items.push({ "Action": "addVariable", "Label": resources.addVariable, "DisplayMode": dataTables.itemDisplayMode.always });
            items.push({ "Action": "selectVariables", "Label": resources.selectVariables, "DisplayMode": dataTables.itemDisplayMode.always });
            items.push({ "Action": "preview", "Label": resources.preview, "DisplayMode": dataTables.itemDisplayMode.nonSelected });
            items.push({ "Action": "delete", "Label": resources.Delete });
            items.push({ "Action": "copyFrom", "Label": resources.copyFrom, "DisplayMode": dataTables.itemDisplayMode.always });

            if (importationFormat == Enum.DtsTypes.Access || importationFormat == Enum.DtsTypes.Csv)
                items.push({ "Action": "load", "Label": resources.load, "DisplayMode": dataTables.itemDisplayMode.noRows });
        }

        return items;
    },
    getContextMenuItems: function () {
        var items = [];

        if (!readOnly)
            items.push({ "Action": "delete", "Label": resources.Delete });

        return items;
    },    
    refreshMappingTable: function () {
        var currentPage = importWizard.mappingDataTable.a4datatable("getCurrentPage");

        $.each(importWizard.mappingData, function (i, e) {
            e.index = i;
        });

        importWizard.mappingDataTable.a4datatable("option", "data", importWizard.mappingData);
        importWizard.mappingDataTable.a4datatable("setCurrentPage", currentPage);

        if (readOnly)
        {
            $(".v-interviewerFieldNameInput input", importWizard.mappingDataTable).a4autocomplete("disable");

            if (importationFormat == Enum.DtsTypes.Access)
                $(".v-sourceFieldNameInput input", importWizard.mappingDataTable).a4autocomplete("disable");
            else
                $(".v-positionInput input", importWizard.mappingDataTable).a4autocomplete("disable");
        }
    },
    recalculateMappings: function (source) {
        importWizard.mappingData = [];

        $.each(source, function (i, e) {
            importWizard.mappingData.push(importWizard.getMappingDataRow(e));
        });

        importWizard.refreshMappingTable();
    },
    getMappingDataRow: function (args) {
        var args = args || {};

        return {
            Position: args.Position || 1,
            SourceRecordNo: args.SourceRecordNo || 1,
            SourceLength: args.SourceLength || 1,
            SourceColumn: args.SourceColumn || 0,
            SourceFieldName: args.SourceFieldName || "",
            ImportAsCode: args.ImportAsCode || false,
            InterviewerFieldName: args.InterviewerFieldName || "",
            InterviewSkipIfPresent: args.InterviewSkipIfPresent || false,
            InterviewSkipIfAbsent: args.InterviewSkipIfAbsent || false,
            IsQuestion: args.IsQuestion || true
        };
    },
    selectVariables: function () {
        var questionsSelectorParams = {
            showSystemVariables: true,
            limitRowCount: 0,
            showFilters: true,
            openEndsIncludedType: 0,
            questionSelectorType: Enum.QuestionSelectorType.Importation,
            ignorePiiSelectionRestriction: true
        };

        modalDialog.showWindow(a4.getProjectAction("QuestionsSelector", "Shared", questionsSelectorParams), 620, 950, {
            beforeClose: function () {
                var questionSelector = $('.fancybox-iframe').contents();
                var confirmed = questionSelector.find(".v-confirmed").val();
                var questions = $('.v-selectedQuestions', questionSelector).val();

                if (confirmed && questions != "") {
                    a4.callServerMethod(a4.getProjectAction("GetQuestionsEditorData", "Importation"),
                    {
                        dtsType: importationFormat,
                        importationDataMapJSON: JSON.stringify(importWizard.mappingData),
                        selectedQuestions: questions
                    },
                    function (result) {
                        if (result != null)
                            importWizard.recalculateMappings(result);
                    });
                }
            }
        });
    },
    createDataMapRow: function (nRow, index) {
        var variableName = $(".v-interviewerFieldName", nRow).html();
        var readOnlyHTMLAttribute = readOnly ? "disabled=\"disabled\"" : "";
        $(nRow).attr("data-index", index);

        var variableInputCell = $(".v-interviewerFieldNameInput", nRow).html('<input type="text" value="' + variableName + '" ' + readOnlyHTMLAttribute + ' />');
        importWizard.initializeMappingVariableAutocomplete($("input", variableInputCell));

        if (importationFormat == Enum.DtsTypes.Access)
        {
            var fieldValue = $(".v-sourceFieldName", nRow).html();
            var fieldInputCell = $(".v-sourceFieldNameInput", nRow).html('<input type="text" value="' + fieldValue + '" ' + readOnlyHTMLAttribute + ' />');

            importWizard.initializeFieldMappingAutocomplete($("input", fieldInputCell));
        }
        else if (importationFormat == Enum.DtsTypes.Csv || importationFormat == Enum.DtsTypes.Txt)
        {
            var positionInputClass = "";

            if (importationFormat == Enum.DtsTypes.Txt)
                positionInputClass = "h-positionInput";

            var positionValue = $(".v-position", nRow).html();
            var positionInputCell = $(".v-positionInput", nRow).html($("<input type=\"text\" value=\"" + positionValue + "\" class=\"" + positionInputClass + " v-validatePositiveInt\" " + readOnlyHTMLAttribute + " />"));

            if (importationFormat == Enum.DtsTypes.Txt)
            {
                var sourceLengthValue = $(".v-sourceLength", nRow).html();
                var sourceLengthInputCell = $(".v-sourceLengthInput", nRow).html($("<input type=\"text\" value=\"" + sourceLengthValue + "\" class=\"h-lengthInput v-validatePositiveInt\" " + readOnlyHTMLAttribute + " />"));
            }
            else
            {
                importWizard.initializeFieldMappingAutocomplete($("input", positionInputCell));
            }
        }
    },
    deleteMappingRows: function (rows) {
        _.each(rows, function (i) {
            importWizard.mappingData = _.reject(importWizard.mappingData, function (v) { return v.index == i.index; });
        });
        importWizard.refreshMappingTable();
    },
    updateMappingRow: function (idx, key, value) {
        var mapping = _.find(importWizard.mappingData, function (v) { return v.index == idx; });

        if (mapping)
            mapping[key] = value;
    },
    validateFiles: function () {
        var isValid = true;

        if (importationFormat != Enum.DtsTypes.CaseGenerator && $("#fileUploadContainer form.file-upload-field.uploaded", importWizard.context).length <= 0) {
            a4.showErrorMessage(resources.fileInputError);
            isValid = false;
        }

        return isValid;
    },
    validateFieldMappingRows: function () {
        var isValid = true;

        if (importWizard.formatHasMappingTable())
        {
            isValid = Array.isArray(importWizard.mappingData) && importWizard.mappingData.length > 0;

            if (isValid)
            {
                var verifiedValues = [];

                $.each(importWizard.mappingData, function (i, e) {
                    if (e.InterviewerFieldName.trim().length == 0 ||
                        (e.SourceColumn && String(e.SourceColumn).trim().length == 0) ||
                        verifiedValues.indexOf(e.InterviewerFieldName.trim()) !== -1 ||
                        (importationFormat == Enum.DtsTypes.Txt && (e.SourceLength == null || String(e.SourceLength).trim().length == 0))) {
                        isValid = false;
                        return false;
                    }
                    verifiedValues.push(e.InterviewerFieldName);
                });
            }

            if (isValid)
            {
                $("#ImportTaskConfiguration_ImportationDataMapJson", importWizard.context).val(JSON.stringify(importWizard.mappingData));
            }
            else
            {
                importWizard.popupScrollToBottom();
                a4.showErrorMessage(resources.mappingError);
            }
        }

        return isValid;
    },
    getImportTaskConfiguration: function () {
        if (typeof importationFormat == "undefined")
            return null;

        var importTaskConfiguration = {
            TaskName: $("#Title", importWizard.context).val(),     
            ProjectId: $("#ProjectId", importWizard.context).val(),
            DuplicatePhoneNumbersOption: $("#ImportTaskConfiguration_DuplicateRecordNumbersOption", importWizard.context).val(),
            DuplicateRecordNumbersOption: $("#ImportTaskConfiguration_DuplicatePhoneNumbersOption", importWizard.context).val(),
            NumberOfRecordsToImport: $("#ImportTaskConfiguration_NumberOfRecordsToImport", importWizard.context).val(),
            SkipFirstRecord: $("#ImportTaskConfiguration_SkipFirstRecord", importWizard.context).is(':checked'),
            ImportAsInactiveSample: $("#ImportTaskConfiguration_ImportAsInactiveSample", importWizard.context).is(':checked'),
            ImportBlankResponse: $("#ImportTaskConfiguration_ImportBlankResponse", importWizard.context).is(':checked'),
            IncludeRolesInfo: $("#ExtractTaskConfiguration_IncludeRolesInfo", importWizard.context).is(':checked'),
            StartNumberingRespondentAt: $("#ImportTaskConfiguration_StartNumberingRespondentAt", importWizard.context).val(),
            AddValueToRecordNumber: $("#ImportTaskConfiguration_AddValueToRecordNumber", importWizard.context).val(),
            ValidateWithDoNotCallList: $("#ImportTaskConfiguration_ValidateWithDoNotCallList", importWizard.context).is(':checked'),
            ExtractTimeZoneFromAreaCode: $("#ImportTaskConfiguration_ExtractTimeZoneFromAreaCode", importWizard.context).is(':checked'),
            UpdateResponsesOnly: $("#ImportTaskConfiguration_UpdateResponsesOnly", importWizard.context).is(':checked'),
            UpdateResponsesBaseField: $("#ImportTaskConfiguration_UpdateResponsesBaseField", importWizard.context).is(':checked'),
            ImportCallHistory: $("#ImportTaskConfiguration_ImportCallHistory", importWizard.context).is(':checked'),
            ImportAllFields: $("#ImportTaskConfiguration_ImportAllFields", importWizard.context).is(':checked'),
            FieldDelimitor: $("#ImportTaskConfiguration_FieldDelimitor", importWizard.context).val(),        
            ImportTimeSlots: $("#ImportTaskConfiguration_ImportTimeSlots", importWizard.context).is(':checked'),
            ImportQuotas: $("#ImportTaskConfiguration_ImportQuotas", importWizard.context).is(':checked'),
            ImportFieldOptions: $("#ImportTaskConfiguration_ImportFieldOptions", importWizard.context).is(':checked'),
            AllowRenumbering: $("#ImportTaskConfiguration_AllowRenumbering", importWizard.context).is(':checked'),
            AccessTableToImport: $("#ImportTaskConfiguration_AccessTableToImport", importWizard.context).val() || null,
            ImportCallBackSettings: $("#ImportTaskConfiguration_AccessTableToImport", importWizard.context).is(':checked'),
            SourceFile: importWizard.getFileName(),
            Adaptor: importationFormat,
            FileServerPath: importWizard.getFilePath(),
            PinOption: $("#ImportTaskConfiguration_PinOption", importWizard.context).val(),
            AutoGeneratePin: this.PinOption == Enum.PinOptions.Generate ? true : false,
            PinGenerationMask: $("#ImportTaskConfiguration_PinGenerationMask", importWizard.context).val(),
            PinQuestion: $("#ImportTaskConfiguration_PinQuestion", importWizard.context).val(),
            ImportationDataMap: importWizard.formatHasMappingTable() ? importWizard.mappingData : [],
            ImportationDataMapJson: importWizard.formatHasMappingTable() ? JSON.stringify(importWizard.mappingData) : "",
            SourceFilesNames: ""
        };    
        
        // get all file names
        var sourceFiles = [];

        $("#fileUploadContainer .h-fileUploadField.uploaded").each(function (i, e) {
            sourceFiles.push($(this).attr("data-fname"));
        });

        if (sourceFiles.length > 0)
            importTaskConfiguration.SourceFilesNames = sourceFiles.join(",")

        return importTaskConfiguration;
    },
    getFileName: function () {
        return $(".v-fileUploadSection form", importWizard.context).first().attr("data-fname");
    },
    getFilePath: function () {
        return $("#ImportTaskConfiguration_FileServerPath", importWizard.context).val();
    },
    getFullFilePath: function () {
        var fileName = importWizard.getFileName();
        return (typeof fileName !== "undefined" &&  fileName != "") ? importWizard.getFilePath() + "\\\\" + importWizard.getFileName() : "";
    },
    popupScrollToBottom: function() {
        var popupContent = importWizard.context.find(".content")

        if (popupContent)
            popupContent.animate({ scrollTop: popupContent.scrollTop() + popupContent.height() });
    },
    changeToolbarButtonsState: function (isDisabled) {
        $(".v-fieldVariableMappingTable .v-toolBarButton", importWizard.context).toggleClass("disabled", isDisabled);
    }
};

var fileUploader = {
    container: null,
    uploadFields: null,
    uploadFieldModel: null,
    multipleFiles: false,
    initialize: function () {
        fileUploader.multipleFiles = (importationFormat == Enum.DtsTypes.CommandCenter);

        var multipleAttr = fileUploader.multipleFiles ? "multiple" : "";
        var fileInput = '<input name="file" type="file" class="v-fileUpload" ' + multipleAttr + ' /><span class="v-allowedExtensions"></span>';
        var fileSelection = '<div class="v-fileSelect hidden"><input class="h-files-autocomplete" type="text" value="" /></div>';
        var sourceFile = $("#ImportTaskConfiguration_SourceFile", importWizard.context).val().trim();
        var sourceFiles = $("#ImportTaskConfiguration_SourceFilesNames", importWizard.context).val().trim();

        fileUploader.container = $("#fileUploadContainer", importWizard.context);
        fileUploader.uploadFieldModel = $('<form class="file-upload-field h-fileUploadField">' + fileInput + fileSelection + '<span class="file-name v-fileNames"></span>' + voxco.icons.getIcon("remove", "h-deleteFile delete-file-button") + voxco.icons.getIcon("loading", "upload-sample-spin") + '</form>');
        fileUploader.showAllowedExtensions(fileUploader.uploadFieldModel);

        if (sourceFile != "")
        {
            var uploadField = fileUploader.uploadFieldModel.clone();
            var fileNames = "";

            if (fileUploader.multipleFiles)
            {
                $.each(sourceFiles.split(","), function (i, e) {
                    fileNames += "<div>" + e + "</div>";
                });
            }
            else
            {
                fileNames = sourceFile;
            }

            uploadField.find(".v-fileNames").html(fileNames);
            uploadField.attr("data-fname", sourceFiles);
            uploadField.removeClass("uploading").addClass("uploaded");
            fileUploader.container.prepend(uploadField);

            if (!readOnly)
            {
                if (importWizard.mappingFields.length == 0 && (importationFormat == Enum.DtsTypes.Access || importationFormat == Enum.DtsTypes.Csv))
                {
                    var autocompleteInput = $(".v-positionInput input", importWizard.mappingDataTable);
                    var selectedTable = null;

                    if (importationFormat == Enum.DtsTypes.Access)
                    {
                        autocompleteInput = $(".v-sourceFieldNameInput input", importWizard.mappingDataTable)
                        selectedTable = $(".v-accessTableToImport", importWizard.context).val();
                    }

                    $.when(fileUploader.refreshFieldsDataTable(sourceFile, selectedTable, false)).then(function () {
                        importWizard.initializeFieldMappingAutocomplete(autocompleteInput);
                    });
                }
            }
            
            $(".v-fileSourceContainer", importWizard.context).toggleClass("hidden", true);
            fileUploader.container.find(".v-allowedExtensions").hide();

            if (importationFormat == Enum.DtsTypes.Csv)
                $(".v-autoFieldMappingSection", importWizard.context).toggleClass("hidden", true);
        }
        else
        {
            importWizard.changeToolbarButtonsState(true);

            // Create initial upload field
            if (!readOnly)
                fileUploader.addNewUploadField();
        }
    },
    bindEvents: function () {
        fileUploader.container.on("change", ".h-fileUploadField input", function () {
            var uploadContainerForm = $(this).closest(".h-fileUploadField");
            var uploadFrameName = ("uploader" + (new Date()).getTime());
            var uploadFrame = $("<iframe name=\"" + uploadFrameName + "\" src=\"about:blank\" style=\"display: none;\" />");
            var isAutocomplete = $(this).hasClass("h-files-autocomplete");
            var fileName = fileUploader.returnValidFileNames(isAutocomplete ? $(this).val() : $(this).prop("files"), isAutocomplete);

            if (fileName != "") {
                $("body").append(uploadFrame);

                uploadContainerForm.addClass("uploading");
                uploadContainerForm.find(".upload-sample-spin").show();
                uploadContainerForm.find(".v-allowedExtensions").hide();
                $(".v-fileSourceContainer", importWizard.context).addClass("hidden");
                $(".v-fileNames", uploadContainerForm).html(fileName);

                if (importationFormat == Enum.DtsTypes.Csv)
                    $(".v-autoFieldMappingSection", importWizard.context).addClass("hidden");

                setTimeout(function () {
                    var callback = function () {
                        uploadContainerForm.removeClass("uploading");
                        uploadContainerForm.addClass("uploaded");
                        uploadContainerForm.find(".upload-sample-spin").hide();
                        importWizard.changeToolbarButtonsState(false);
                    };

                    if (isAutocomplete)
                        fileUploader.selectFile(uploadContainerForm, uploadFrame, fileName, callback);
                    else
                        fileUploader.uploadFile(uploadContainerForm, uploadFrame, callback);
                }, 500);
            }
            else
            {
                importWizard.changeToolbarButtonsState(true);
                uploadContainerForm.remove();
                fileUploader.addNewUploadField();
                a4.showErrorMessage(resources.wrongFileExtension);
            }
        });

        fileUploader.container.on("click", ".h-deleteFile", function () {
            var uploadContainerForm = $(this).closest(".h-fileUploadField");
            var fileName = uploadContainerForm.attr("data-fname");

            if (fileName != null && fileName !== "")
            {
                uploadContainerForm.remove();
                    importWizard.changeToolbarButtonsState(true);
              
                $("#SourceFileName", importWizard.context).val("");
                $("#ImportTaskConfiguration_SourceFile", importWizard.context).val("");
                $("#ImportTaskConfiguration_SourceFilesNames", importWizard.context).val("");

                if (importationFormat == Enum.DtsTypes.Access)
                    $('.v-accessTableToImport').find('option').remove();
            }
            
            fileUploader.addNewUploadField();

            if (importationFormat == Enum.DtsTypes.Csv)
                $(".v-autoFieldMappingSection", importWizard.context).toggleClass("hidden", false);
        });
    },
    returnValidFileNames: function (files, isAutocomplete) {
        var validFiles = "";

        if (typeof files !== "undefined" && files.length > 0)
        {
            if (isAutocomplete && importWizard.allowedFormatExtensions.indexOf(files.split('.').pop().toLowerCase()) > -1)
            {
                validFiles = files;
            }
            else if (!isAutocomplete)
            {
                $.each(files, function (i, e) {
                    var fileName = e.name;
                    var extension = fileName.split('.').pop();

                    if (importWizard.allowedFormatExtensions.indexOf(extension.toLowerCase()) == -1)
                    {
                        validFiles = "";
                        return false;
                    }
                    else
                        validFiles += "<div>" + fileName + "</div>";

                });
            }
        }

        return validFiles;
    },
    initializeFilesAutocomplete: function () {
        $(".h-files-autocomplete", fileUploader.container).a4autocomplete({
            ajaxAction: a4.getProjectAction("GetImportationFiles", "Importation"),
            ajaxParams: { dtsType: importationFormat },
            valueProperty: "Name",
            labelProperty: "Name"
        });
    },
    refreshFieldsDataTable: function (fileName, selectedValue, doRecalculateMappings) {
        var args = {
            dtsType: importationFormat,
            filePath: importWizard.getFullFilePath(),
            selectedValue: selectedValue
        };

        if (importationFormat == Enum.DtsTypes.Csv)
            args.delimiter = $(".v-fileDelimiter", importWizard.context).val();

        return a4.callServerMethod(
            a4.getProjectAction("GetDataMappingFields", "Importation"), args,
			function (result) {
			    if (result !== null)
			    {
			        importWizard.mappingFields = result;

			        if (doRecalculateMappings)
			            importWizard.recalculateMappings(importWizard.mappingFields);
			        else
			            importWizard.refreshMappingTable();
			    }
			}
		);
    },
    refreshAccessTablesFields: function (fileName, callback) {
        a4.callServerMethod(a4.getProjectAction("GetAccessTables", "Importation"), { fileName: fileName },
            function (result) {
                $("#ImportTaskConfiguration_AccessTablesString", importWizard.context).val("");
                $(".v-accessTableToImport", importWizard.context).empty();

                if (result) {
                    $("#ImportTaskConfiguration_AccessTablesString", importWizard.context).val(result.toString());

                    for (var i = 0, l = result.length; i < l; i++)
                    {
                        $(".v-accessTableToImport", importWizard.context).append("<option value=\"" + result[i] + "\">" + result[i] + "</option>");
                    }
                }

                $(".v-accessTableToImport", importWizard.context).trigger("change");

                if (callback)
                    callback();
            }
        );
    },
    addNewUploadField: function () {
        var uploadField = fileUploader.uploadFieldModel.clone();
        fileUploader.container.prepend(uploadField);
        fileUploader.initializeFilesAutocomplete();
        $(".v-fileSourceContainer", importWizard.context).toggleClass("hidden", false);

        if ($(".v-fileSource:checked", importWizard.context).val() == "Select") {
            $(".v-fileUpload, .v-allowedExtensions", uploadField).toggleClass("hidden", true);
            $(".v-fileSelect", uploadField).toggleClass("hidden", false);
        }
        else {
            fileUploader.showAllowedExtensions(uploadField);
        }
    },
    showAllowedExtensions: function (context) {
        if (importWizard.allowedFormatExtensions != null)
            $(".v-allowedExtensions", context).html(" (" + importWizard.allowedFormatExtensions.join(", ") + ")");
    },
    uploadFile: function (uploadContainerForm, uploadFrame, callback) {
        var dataForm = new FormData($(".file-upload-field", importWizard.context)[0]);     
        dataForm.append("dtsType", importationFormat);

        $.ajax({
            type: "POST",
            url: a4.getProjectAction("UploadImportationFile", "Importation"),
            headers: { "X-CSRF-TOKEN": $(aft).val() },
            data: dataForm,
            async: false,
            cache: false,
            contentType: false,
            processData: false,
            success: function (result) {
                fileUploader.finalizeFileSelecting(uploadContainerForm, uploadFrame, result, callback);
            },
            error: function (xhr, status, error) {
                uploadContainerForm.remove();
                fileUploader.addNewUploadField();

                if (xhr && typeof xhr.responseJSON != "undefined")
                    a4.showErrorMessage(xhr.responseJSON.Message);
            }
        });
    },
    selectFile: function (uploadContainerForm, uploadFrame, fileName, callback) {
        $(".v-fileSelect", uploadContainerForm).toggleClass("hidden", true);
        fileUploader.finalizeFileSelecting(uploadContainerForm, uploadFrame, fileName, callback);
    },
    finalizeFileSelecting: function (uploadContainerForm, uploadFrame, fileNames, callback) {
        uploadContainerForm.attr("data-fname", fileNames);
        $("#ImportTaskConfiguration_SourceFilesNames", importWizard.context).val(fileNames);
        $(".v-fileNames", uploadContainerForm).html(fileNames.replace(",", "<br />"));

        if (fileNames.length > 0) {
            var sourceFile = fileNames.split(',')[0];

            $("#SourceFileName", importWizard.context).val(sourceFile);
            $("#ImportTaskConfiguration_SourceFile", importWizard.context).val(sourceFile);

            if (importationFormat == Enum.DtsTypes.Access)
            {
                fileUploader.refreshAccessTablesFields(sourceFile, callback);
            }
            else if (importationFormat == Enum.DtsTypes.Csv)
            {
                fileUploader.refreshFieldsDataTable(sourceFile, null, $(".v-autoFieldMapping", importWizard.context).is(":checked"));

                if (callback)
                    callback();
            }
            else if (callback) {
                callback();
            }
        }

        setTimeout(function () {
            uploadFrame.remove();
        }, 100);
    }
};

$(document).ready(function () {
    if (importWizard.context.length > 0)
    {
        importWizard.allowedFormatExtensions = allowedFormatExtensions[importationFormat];

        importWizard.initialize();
        importWizard.bindEvents();
        importWizard.initializeAutocompletes();

        fileUploader.initialize();
        fileUploader.bindEvents();
        fileUploader.initializeFilesAutocomplete();

        importWizard.setFormElementsReadOnly(readOnly);
    }
});